Use LigaKreglarskaPrzyklad;
GO

CREATE VIEW R04_imiona_nazwiska_i_adresy_kreglarzy
AS
SELECT     TOP 100 PERCENT NazwiskoKreglarza, ImieKreglarza, AdresKreglarza, MiastoKreglarza, StanZamKreglarza, KodPocztowyKreglarza
FROM         Kreglarze
ORDER BY NazwiskoKreglarza, ImieKreglarza;
GO

CREATE VIEW R04_zestawienie_wynikow_kreglarzy
AS
SELECT     Wyniki_kreglarzy.*
FROM         Wyniki_kreglarzy;
GO

CREATE VIEW R04_lista_zepolow
AS
SELECT     TOP 100 PERCENT NazwaDruzyny
FROM         Druzyny
ORDER BY NazwaDruzyny;
GO

CREATE VIEW R04_daty_i_miejsca_turniejow
AS
SELECT     TOP 100 PERCENT DataTurnieju, LokalizacjaTurnieju
FROM         Turnieje
ORDER BY DataTurnieju DESC, LokalizacjaTurnieju;
GO

CREATE VIEW R04_lokalizacje_turniejow
AS
SELECT DISTINCT LokalizacjaTurnieju
FROM         Turnieje;
GO

CREATE VIEW R05_wyniki_z_handicapem_i_bez
AS
SELECT     TOP 100 PERCENT IDKreglarza, IDMeczu, NumerGry, WynikHandicap, WynikCzysty, WynikHandicap - WynikCzysty AS RoznicaPunktowa
FROM         Wyniki_kreglarzy
ORDER BY IDKreglarza, IDMeczu, NumerGry;
GO

CREATE VIEW R05_nazwiska_adresy_do_mailingu
AS
SELECT     TOP 100 PERCENT ImieKreglarza + ' ' + NazwiskoKreglarza AS FullName, AdresKreglarza, 
                      MiastoKreglarza + ', ' + StanZamKreglarza + '  ' + KodPocztowyKreglarza AS MiastoStanKod, KodPocztowyKreglarza
FROM         Kreglarze
ORDER BY KodPocztowyKreglarza;
GO

CREATE VIEW R05_daty_przyszlorocznych_turniejow
AS
SELECT     TOP 100 PERCENT LokalizacjaTurnieju, DataTurnieju, DateAdd(d, 364, DataTurnieju) AS PrzyszlorocznaDataTurnieju
FROM         Turnieje
ORDER BY LokalizacjaTurnieju;
GO

CREATE VIEW R05_lista_telefonow
AS
SELECT     TOP 100 PERCENT NazwiskoKreglarza + ', ' + ImieKreglarza AS Kreglarz, TelefonKreglarza AS Telefon
FROM         Kreglarze
ORDER BY Kreglarz;
GO

CREATE VIEW R05_sklad_druzyn
AS
SELECT     TOP 100 PERCENT IDDruzyny, NazwiskoKreglarza + ', ' + ImieKreglarza AS Kreglarz
FROM         Kreglarze
ORDER BY IDDruzyny, Kreglarz;
GO

CREATE VIEW R06_kreglarze_z_5_miast_i_druzyn_od_5_do_8
AS
SELECT     TOP 100 PERCENT ImieKreglarza, NazwiskoKreglarza, MiastoKreglarza, IDDruzyny
FROM         Kreglarze
WHERE     (MiastoKreglarza IN ('Bellevue', 'Bothell', 'Duvall', 'Redmond', 'Woodinville')) AND (IDDruzyny BETWEEN 5 AND 8)
ORDER BY MiastoKreglarza, NazwiskoKreglarza;
GO

CREATE VIEW R06_turnieje_trzech_kregielni
AS
SELECT     TOP 100 PERCENT LokalizacjaTurnieju, DataTurnieju
FROM         Turnieje
WHERE     (LokalizacjaTurnieju IN ('Red Rooster Lanes', 'Thunderbird Lanes', 'Bolero Lanes'))
ORDER BY LokalizacjaTurnieju, DataTurnieju;
GO

CREATE VIEW R06_wygrane_w_grze_3
AS
SELECT     IDWygranejDruzyny, IDMeczu, NumerGry
FROM         Gry_meczowe
WHERE     (IDMeczu <= 10) AND (NumerGry = 3);
GO

CREATE VIEW R06_kreglarze_na_H_druzyny_3_i_5
AS
SELECT     ImieKreglarza, NazwiskoKreglarza, IDDruzyny
FROM         Kreglarze
WHERE     (NazwiskoKreglarza LIKE 'H%') AND (IDDruzyny IN (3, 4, 5));
GO

CREATE VIEW R06_zestawienie_turniejow_wrzesien_2012
AS
SELECT     DataTurnieju, LokalizacjaTurnieju
FROM         Turnieje
WHERE     (DataTurnieju BETWEEN '9/1/2012' AND '9/30/2012');
GO

CREATE VIEW R08_wyniki_kreglarzy
AS
SELECT     Wyniki_kreglarzy.IDMeczu, Druzyny.NazwaDruzyny, Kreglarze.ImieKreglarza + ' ' + Kreglarze.NazwiskoKreglarza AS ImieNazwiskoKreg, 
                      Wyniki_kreglarzy.NumerGry, Wyniki_kreglarzy.WynikCzysty
FROM         Druzyny INNER JOIN
                      Kreglarze ON Druzyny.IDDruzyny = Kreglarze.IDDruzyny INNER JOIN
                      Wyniki_kreglarzy ON Kreglarze.IDKreglarza = Wyniki_kreglarzy.IDKreglarza;
GO

CREATE VIEW R08_kreglarze_z_tym_samym_kodem_pocztowym
AS
SELECT     Kreglarze.NazwiskoKreglarza + ', ' + Kreglarze.ImieKreglarza AS PierwszyKreglarz, Kreglarze.KodPocztowyKreglarza, 
                      Kreglarze2.NazwiskoKreglarza + ', ' + Kreglarze2.ImieKreglarza AS DrugiKreglarz
FROM         Kreglarze INNER JOIN
                      Kreglarze Kreglarze2 
             ON Kreglarze.IDKreglarza <> Kreglarze2.IDKreglarza 
                AND Kreglarze.KodPocztowyKreglarza = Kreglarze2.KodPocztowyKreglarza;
GO

CREATE VIEW R08_dobrzy_kreglarze_na_kregielniach_Thunderbird_i_Bolero
AS
SELECT     KreglarzTbird.ImieNazwiskoKreg
FROM         (SELECT DISTINCT Kreglarze.IDKreglarza, (Kreglarze.NazwiskoKreglarza + ', ' + Kreglarze.ImieKreglarza) AS ImieNazwiskoKreg
                       FROM          ((Kreglarze INNER JOIN
                                              Wyniki_kreglarzy ON Kreglarze.IDKreglarza = Wyniki_kreglarzy.IDKreglarza) INNER JOIN
                                              Mecze_turniejowe ON Mecze_turniejowe.IDMeczu = Wyniki_kreglarzy.IDMeczu) INNER JOIN
                                              Turnieje ON Turnieje.IDTurnieju = Mecze_turniejowe.IDTurnieju
                       WHERE      Turnieje.LokalizacjaTurnieju = 'Thunderbird Lanes' AND Wyniki_kreglarzy.WynikCzysty >= 170) KreglarzTbird INNER JOIN
                          (SELECT DISTINCT Kreglarze.IDKreglarza, (Kreglarze.NazwiskoKreglarza + ', ' + Kreglarze.ImieKreglarza) AS ImieNazwiskoKreg
                            FROM          ((Kreglarze INNER JOIN
                                                   Wyniki_kreglarzy ON Kreglarze.IDKreglarza = Wyniki_kreglarzy.IDKreglarza) INNER JOIN
                                                   Mecze_turniejowe ON Mecze_turniejowe.IDMeczu = Wyniki_kreglarzy.IDMeczu) INNER JOIN
                                                   Turnieje ON Turnieje.IDTurnieju = Mecze_turniejowe.IDTurnieju
                            WHERE      Turnieje.LokalizacjaTurnieju = 'Bolero Lanes' AND Wyniki_kreglarzy.WynikCzysty >= 170) KreglarzBolero ON 
                      KreglarzTbird.IDKreglarza = KreglarzBolero.IDKreglarza;
GO

CREATE VIEW R08_druzyny_i_kreglarze
AS
SELECT     Druzyny.NazwaDruzyny, Kreglarze.NazwiskoKreglarza + ', ' + Kreglarze.ImieKreglarza AS ImieNazwiskoKreg
FROM         Druzyny INNER JOIN
                      Kreglarze ON Druzyny.IDDruzyny = Kreglarze.IDDruzyny;
GO

CREATE VIEW R08_druzyny_i_kapitanowie
AS
SELECT     Druzyny.NazwaDruzyny, Kreglarze.NazwiskoKreglarza + ', ' + Kreglarze.ImieKreglarza AS Kapitan
FROM         Druzyny INNER JOIN
                      Kreglarze ON Druzyny.IDKapitana = Kreglarze.IDKreglarza;
GO

CREATE VIEW R08_wyniki_meczow_turniejowych
AS
SELECT   Turnieje.IDTurnieju AS Tourney, Turnieje.LokalizacjaTurnieju AS Lokalizacja, Mecze_turniejowe.IDMeczu, Mecze_turniejowe.Tory, DruzynaNieparzysta.NazwaDruzyny AS DruzynaTorNieparzysty, DruzynaParzysta.NazwaDruzyny AS DruzynaTorParzysty, Gry_meczowe.NumerGry AS GameNo, Zwyciezca.NazwaDruzyny AS Zwyciezca
FROM       ((((Turnieje INNER JOIN 
            Mecze_turniejowe ON Turnieje.IDTurnieju = Mecze_turniejowe.IDTurnieju) INNER JOIN 
            Druzyny AS DruzynaNieparzysta ON DruzynaNieparzysta.IDDruzyny = Mecze_turniejowe.IDDruzynyTorNieparzysty) INNER JOIN 
            Druzyny AS DruzynaParzysta ON DruzynaParzysta.IDDruzyny = Mecze_turniejowe.IDDruzynyTorParzysty) INNER JOIN 
            Gry_meczowe ON Gry_meczowe.IDMeczu = Mecze_turniejowe.IDMeczu) INNER JOIN 
            Druzyny AS Zwyciezca ON Zwyciezca.IDDruzyny = Gry_meczowe.IDWygranejDruzyny;
GO

CREATE VIEW R09_wszyscy_kreglarze_i_wyniki_powyzej_180
AS
SELECT     TOP 100 PERCENT Kreglarze.NazwiskoKreglarza + ', ' + Kreglarze.ImieKreglarza AS ImieNazwiskoKreg, TI.DataTurnieju, TI.LokalizacjaTurnieju, 
                      TI.IDMeczu, TI.WynikCzysty
FROM         Kreglarze LEFT OUTER JOIN
                          (SELECT     Turnieje.DataTurnieju, Turnieje.LokalizacjaTurnieju, Wyniki_kreglarzy.IDMeczu, Wyniki_kreglarzy.IDKreglarza, 
                                                   Wyniki_kreglarzy.WynikCzysty
                            FROM          (Wyniki_kreglarzy INNER JOIN
                                                   Mecze_turniejowe ON Wyniki_kreglarzy.IDMeczu = Mecze_turniejowe.IDMeczu) INNER JOIN
                                                   Turnieje ON Turnieje.IDTurnieju = Mecze_turniejowe.IDTurnieju
                            WHERE      Wyniki_kreglarzy.WynikCzysty > 180) TI ON Kreglarze.IDKreglarza = TI.IDKreglarza
ORDER BY Kreglarze.NazwiskoKreglarza + ', ' + Kreglarze.ImieKreglarza;
GO

CREATE VIEW R09_wyniki_meczow_wszystkie_turnieje
AS
SELECT     TOP 100 PERCENT Turnieje.IDTurnieju, Turnieje.DataTurnieju, Turnieje.LokalizacjaTurnieju, TM.IDMeczu, TM.NumerGry, 
                      TM.Zwyciezca
FROM         Turnieje LEFT OUTER JOIN
                          (SELECT     Mecze_turniejowe.IDTurnieju, Mecze_turniejowe.IDMeczu, Gry_meczowe.NumerGry, Druzyny.NazwaDruzyny AS Zwyciezca
                            FROM          Mecze_turniejowe INNER JOIN
                                                   (Druzyny INNER JOIN
                                                   Gry_meczowe ON Druzyny.IDDruzyny = Gry_meczowe.IDWygranejDruzyny) ON Mecze_turniejowe.IDMeczu = Gry_meczowe.IDMeczu) TM ON 
                      Turnieje.IDTurnieju = TM.IDTurnieju
ORDER BY Turnieje.IDTurnieju;
GO

CREATE VIEW R09_mecze_nierozegrane
AS
SELECT     Mecze_turniejowe.IDMeczu, Mecze_turniejowe.IDTurnieju, Druzyny.NazwaDruzyny AS DruzynaTorNieparzysty, 
                      Druzyny_1.NazwaDruzyny AS DruzynaTorParzysty
FROM         Druzyny Druzyny_1 INNER JOIN
                      Druzyny INNER JOIN
                      Mecze_turniejowe LEFT OUTER JOIN
                      Gry_meczowe ON Mecze_turniejowe.IDMeczu = Gry_meczowe.IDMeczu ON 
                      Druzyny.IDDruzyny = Mecze_turniejowe.IDDruzynyTorNieparzysty ON Druzyny_1.IDDruzyny = Mecze_turniejowe.IDDruzynyTorParzysty
WHERE     (Gry_meczowe.IDMeczu IS NULL);
GO

CREATE VIEW R09_turnieje_jeszcze_nie_rozgrywane
AS
SELECT     Turnieje.IDTurnieju, Turnieje.DataTurnieju, Turnieje.LokalizacjaTurnieju
FROM         Turnieje LEFT OUTER JOIN
                      Mecze_turniejowe ON Turnieje.IDTurnieju = Mecze_turniejowe.IDTurnieju
WHERE     (Mecze_turniejowe.IDMeczu IS NULL);
GO

CREATE VIEW R10_harmonogram_rozgrywek
AS
SELECT     TOP 100 PERCENT Harmonogram.*
FROM         (SELECT     Turnieje.LokalizacjaTurnieju, Turnieje.DataTurnieju, Mecze_turniejowe.IDMeczu, Druzyny.NazwaDruzyny, 
                                              Kreglarze.NazwiskoKreglarza + ', ' + Kreglarze.ImieKreglarza AS Kapitan, 'Tor nieparzysty' AS Tor
                       FROM          ((Turnieje INNER JOIN
                                              Mecze_turniejowe ON Turnieje.IDTurnieju = Mecze_turniejowe.IDTurnieju) INNER JOIN
                                              Druzyny ON Druzyny.IDDruzyny = Mecze_turniejowe.IDDruzynyTorNieparzysty) INNER JOIN
                                              Kreglarze ON Kreglarze.IDKreglarza = Druzyny.IDKapitana
                       UNION ALL
                       SELECT     Turnieje.LokalizacjaTurnieju, Turnieje.DataTurnieju, Mecze_turniejowe.IDMeczu, Druzyny.NazwaDruzyny, 
                                             Kreglarze.NazwiskoKreglarza + ', ' + Kreglarze.ImieKreglarza AS Kapitan, 'Tor parzysty' AS Tor
                       FROM         ((Turnieje INNER JOIN
                                             Mecze_turniejowe ON Turnieje.IDTurnieju = Mecze_turniejowe.IDTurnieju) INNER JOIN
                                             Druzyny ON Druzyny.IDDruzyny = Mecze_turniejowe.IDDruzynyTorParzysty) INNER JOIN
                                             Kreglarze ON Kreglarze.IDKreglarza = Druzyny.IDKapitana) Harmonogram
ORDER BY 2, 3;
GO

CREATE VIEW R10_dobrzy_kreglarze_Thunderbird_Bolero_UNION
AS
SELECT     Turnieje.LokalizacjaTurnieju, Kreglarze.NazwiskoKreglarza, Kreglarze.ImieKreglarza, Wyniki_kreglarzy.WynikCzysty
FROM         Kreglarze INNER JOIN
                      ((Turnieje INNER JOIN
                      Mecze_turniejowe ON (Turnieje.IDTurnieju = Mecze_turniejowe.IDTurnieju)) INNER JOIN
                      Wyniki_kreglarzy ON (Mecze_turniejowe.IDMeczu = Wyniki_kreglarzy.IDMeczu)) ON (Kreglarze.IDKreglarza = Wyniki_kreglarzy.IDKreglarza)
WHERE     Turnieje.LokalizacjaTurnieju = 'Thunderbird Lanes' AND Wyniki_kreglarzy.WynikCzysty > 165
UNION
SELECT     Turnieje.LokalizacjaTurnieju, Kreglarze.NazwiskoKreglarza, Kreglarze.ImieKreglarza, Wyniki_kreglarzy.WynikCzysty
FROM         Kreglarze INNER JOIN
                      ((Turnieje INNER JOIN
                      Mecze_turniejowe ON (Turnieje.IDTurnieju = Mecze_turniejowe.IDTurnieju)) INNER JOIN
                      Wyniki_kreglarzy ON (Mecze_turniejowe.IDMeczu = Wyniki_kreglarzy.IDMeczu)) ON (Kreglarze.IDKreglarza = Wyniki_kreglarzy.IDKreglarza)
WHERE     Turnieje.LokalizacjaTurnieju = 'Bolero Lanes' AND Wyniki_kreglarzy.WynikCzysty > 150;
GO

CREATE VIEW R10_dobrzy_kreglarze_Thunderbird_Bolero_WHERE
AS
SELECT     Turnieje.LokalizacjaTurnieju, Kreglarze.NazwiskoKreglarza, Kreglarze.ImieKreglarza, Wyniki_kreglarzy.WynikCzysty
FROM         Turnieje INNER JOIN
                      Kreglarze INNER JOIN
                      Mecze_turniejowe INNER JOIN
                      Wyniki_kreglarzy ON Mecze_turniejowe.IDMeczu = Wyniki_kreglarzy.IDMeczu ON Kreglarze.IDKreglarza = Wyniki_kreglarzy.IDKreglarza ON 
                      Turnieje.IDTurnieju = Mecze_turniejowe.IDTurnieju
WHERE     (Turnieje.LokalizacjaTurnieju = 'Thunderbird Lanes') AND (Wyniki_kreglarzy.WynikCzysty > 165) OR
                      (Turnieje.LokalizacjaTurnieju = 'Bolero Lanes') AND (Wyniki_kreglarzy.WynikCzysty > 150);
GO

CREATE VIEW R11_rekordowe_wyniki_kreglarzy
AS
SELECT     ImieKreglarza, NazwiskoKreglarza,
                          (SELECT     MAX(WynikCzysty)
                            FROM          Wyniki_kreglarzy
                            WHERE      Wyniki_kreglarzy.IDKreglarza = Kreglarze.IDKreglarza) AS Rekord
FROM         Kreglarze;
GO

CREATE VIEW R11_kreglarze_i_liczba_rozegranych_gier
AS
SELECT     ImieKreglarza, NazwiskoKreglarza,
                          (SELECT     COUNT(*)
                            FROM          Wyniki_kreglarzy
                            WHERE      Wyniki_kreglarzy.IDKreglarza = Kreglarze.IDKreglarza) AS Gry
FROM         Kreglarze;
GO

CREATE VIEW R11_kreglarze_ze_slabymi_wynikami
AS
SELECT DISTINCT Kreglarze.IDKreglarza, Kreglarze.ImieKreglarza, Kreglarze.NazwiskoKreglarza, Wyniki_kreglarzy.WynikCzysty
FROM         Kreglarze INNER JOIN
                      Wyniki_kreglarzy ON Kreglarze.IDKreglarza = Wyniki_kreglarzy.IDKreglarza
WHERE     (Wyniki_kreglarzy.WynikCzysty < ALL
                          (SELECT     BS2.WynikCzysty
                            FROM          Kreglarze AS B2 INNER JOIN
                                                   Wyniki_kreglarzy AS BS2 ON B2.IDKreglarza = BS2.IDKreglarza
                            WHERE      B2.IDKreglarza <> Kreglarze.IDKreglarza AND B2.IDDruzyny = Kreglarze.IDDruzyny));
GO

CREATE VIEW R11_kapitanowie_druzyn_z_rekordowymi_wynikami
AS
SELECT     Druzyny.NazwaDruzyny, Kreglarze.IDKreglarza, Kreglarze.ImieKreglarza, Kreglarze.NazwiskoKreglarza, 
                      Wyniki_kreglarzy.WynikHandicap
FROM         Kreglarze INNER JOIN
                      Druzyny ON Kreglarze.IDKreglarza = Druzyny.IDKapitana INNER JOIN
                      Wyniki_kreglarzy ON Kreglarze.IDKreglarza = Wyniki_kreglarzy.IDKreglarza
WHERE     (Wyniki_kreglarzy.WynikHandicap > ALL
                          (SELECT     BS2.WynikHandicap
                            FROM          Kreglarze AS B2 INNER JOIN
                                                   Wyniki_kreglarzy AS BS2 ON B2.IDKreglarza = BS2.IDKreglarza
                            WHERE      B2.IDKreglarza <> Kreglarze.IDKreglarza AND B2.IDDruzyny = Kreglarze.IDDruzyny));
GO

CREATE VIEW R12_kreglarze_lepsi_niz_srednia
AS
SELECT     TOP 100 PERCENT NazwiskoKreglarza, ImieKreglarza
FROM         Kreglarze
WHERE     ((SELECT     AVG(CAST(WynikCzysty AS Float))
                         FROM         Wyniki_kreglarzy AS BS
                         WHERE     BS.IDKreglarza = Kreglarze.IDKreglarza) >=
                          (SELECT     AVG(Cast(WynikCzysty AS Float))
                            FROM          Wyniki_kreglarzy))
ORDER BY NazwiskoKreglarza, ImieKreglarza;
GO

CREATE VIEW R12_aktualnie_najwyzszy_handicap
AS
SELECT     MAX(Handicap) AS DuzyHandicap
FROM         (SELECT     ROUND((200 - ROUND
                                                  ((SELECT     AVG(Cast(WynikCzysty AS Float))
                                                      FROM         Wyniki_kreglarzy
                                                      WHERE     Wyniki_kreglarzy.IDKreglarza = Kreglarze.IDKreglarza), 0)) * 0.9, 0) AS Handicap
                       FROM          Kreglarze) Q1;
GO

CREATE VIEW R12_data_ostatniego_zaplanowanego_turnieju
AS
SELECT     MAX(DataTurnieju) AS OstatniaData
FROM         Turnieje;
GO

CREATE VIEW R12_liczba_turniejow_w_kregielni_Red_Rooster
AS
SELECT     COUNT(LokalizacjaTurnieju) AS LiczbaTurniejow
FROM         Turnieje
WHERE     (LokalizacjaTurnieju = 'Red Rooster Lanes');
GO

CREATE VIEW R12_lokalizacja_najstarszych_turniejow
AS
SELECT     LokalizacjaTurnieju
FROM         Turnieje
WHERE     (DataTurnieju =
                          (SELECT     MIN(DataTurnieju)
                            FROM          Turnieje));
GO

CREATE VIEW R13_biezacy_handicap_kreglarza
AS
SELECT     Wyniki_kreglarzy.IDKreglarza, Kreglarze.NazwiskoKreglarza, Kreglarze.ImieKreglarza, SUM(Wyniki_kreglarzy.WynikCzysty) AS SumaKregli, 
                      COUNT(Wyniki_kreglarzy.WynikCzysty) AS RozegraneGry, ROUND(AVG(CAST(Wyniki_kreglarzy.WynikCzysty AS FLOAT)), 0) AS BiezSrd, 
                      ROUND(0.9 * (200 - ROUND(AVG(CAST(Wyniki_kreglarzy.WynikCzysty AS FLOAT)), 0)), 0) AS BzcHcp
FROM         Kreglarze INNER JOIN
                      Wyniki_kreglarzy ON Kreglarze.IDKreglarza = Wyniki_kreglarzy.IDKreglarza
GROUP BY Wyniki_kreglarzy.IDKreglarza, Kreglarze.NazwiskoKreglarza, Kreglarze.ImieKreglarza;
GO

CREATE VIEW R13_srednie_wyniki_kreglarzy
AS
SELECT     Kreglarze.NazwiskoKreglarza + ', ' + Kreglarze.ImieKreglarza AS ImieNazwiskoKreg, AVG(CAST(Wyniki_kreglarzy.WynikCzysty AS FLOAT)) 
                      AS SrdWynikCzysty
FROM         Kreglarze INNER JOIN
                      Wyniki_kreglarzy ON Kreglarze.IDKreglarza = Wyniki_kreglarzy.IDKreglarza
GROUP BY Kreglarze.NazwiskoKreglarza, Kreglarze.ImieKreglarza;
GO

CREATE VIEW R13_rekordowe_wyniki_kreglarzy_grupowanie
AS
SELECT     Kreglarze.ImieKreglarza, Kreglarze.NazwiskoKreglarza, MAX(Wyniki_kreglarzy.WynikCzysty) AS Rekord
FROM         Kreglarze INNER JOIN
                      Wyniki_kreglarzy ON Kreglarze.IDKreglarza = Wyniki_kreglarzy.IDKreglarza
GROUP BY Kreglarze.ImieKreglarza, Kreglarze.NazwiskoKreglarza;
GO

CREATE VIEW R13_rekordowe_wyniki_kreglarzy_podzapytanie
AS
SELECT     ImieKreglarza, NazwiskoKreglarza,
                          (SELECT     MAX(WynikCzysty)
                            FROM          Wyniki_kreglarzy
                            WHERE      Wyniki_kreglarzy.IDKreglarza = Kreglarze.IDKreglarza) AS Rekord
FROM         Kreglarze;
GO

CREATE VIEW R13_wyniki_druzyn_w_meczach_turniejowych
AS
SELECT     Turnieje.IDTurnieju, Turnieje.LokalizacjaTurnieju, Mecze_turniejowe.IDMeczu, Druzyny.NazwaDruzyny, 
                      SUM(Wyniki_kreglarzy.WynikHandicap) AS TotWynikHandicap
FROM         Turnieje INNER JOIN
                      Mecze_turniejowe ON Turnieje.IDTurnieju = Mecze_turniejowe.IDTurnieju INNER JOIN
                      Gry_meczowe ON Mecze_turniejowe.IDMeczu = Gry_meczowe.IDMeczu INNER JOIN
                      Wyniki_kreglarzy ON Gry_meczowe.NumerGry = Wyniki_kreglarzy.NumerGry AND 
                      Gry_meczowe.IDMeczu = Wyniki_kreglarzy.IDMeczu INNER JOIN
                      Kreglarze ON Kreglarze.IDKreglarza = Wyniki_kreglarzy.IDKreglarza INNER JOIN
                      Druzyny ON Druzyny.IDDruzyny = Kreglarze.IDDruzyny
GROUP BY Turnieje.IDTurnieju, Turnieje.LokalizacjaTurnieju, Mecze_turniejowe.IDMeczu, Druzyny.NazwaDruzyny;
GO

CREATE VIEW R14_kreglarze_lepsi_niz_srednia_HAVING
AS
SELECT     TOP 100 PERCENT Kreglarze.NazwiskoKreglarza, Kreglarze.ImieKreglarza
FROM         Kreglarze INNER JOIN
                      Wyniki_kreglarzy ON Kreglarze.IDKreglarza = Wyniki_kreglarzy.IDKreglarza
GROUP BY Kreglarze.NazwiskoKreglarza, Kreglarze.ImieKreglarza
HAVING      (AVG(CAST(Wyniki_kreglarzy.WynikCzysty AS Float)) >=
                          (SELECT     AVG(CAST(WynikCzysty AS FLOAT))
                            FROM          Wyniki_kreglarzy));
GO

CREATE VIEW R14_kreglarze_z_dobrymi_wynikami_bez_hcp
AS
SELECT     Kreglarze.ImieKreglarza, Kreglarze.NazwiskoKreglarza, ROUND(AVG(CAST(Wyniki_kreglarzy.WynikCzysty AS FLOAT)), 0) AS CurrentAverage, 
                      MAX(Wyniki_kreglarzy.WynikCzysty) AS HighGame
FROM         Kreglarze INNER JOIN
                      Wyniki_kreglarzy ON Kreglarze.IDKreglarza = Wyniki_kreglarzy.IDKreglarza
GROUP BY Kreglarze.ImieKreglarza, Kreglarze.NazwiskoKreglarza
HAVING      (MAX(Wyniki_kreglarzy.WynikCzysty) > ROUND(AVG(CAST(Wyniki_kreglarzy.WynikCzysty AS FLOAT)), 0) + 20);
GO

CREATE VIEW R14_superkapitanowie_druzyn
AS
SELECT     Druzyny.IDDruzyny, Kreglarze.IDKreglarza, Kreglarze.ImieKreglarza, Kreglarze.NazwiskoKreglarza, MAX(Wyniki_kreglarzy.WynikCzysty) 
                      AS MaxOfWynikCzysty
FROM         Kreglarze INNER JOIN
                      Wyniki_kreglarzy ON Kreglarze.IDKreglarza = Wyniki_kreglarzy.IDKreglarza INNER JOIN
                      Druzyny ON Kreglarze.IDKreglarza = Druzyny.IDKapitana
GROUP BY Druzyny.IDDruzyny, Kreglarze.IDKreglarza, Kreglarze.ImieKreglarza, Kreglarze.NazwiskoKreglarza
HAVING      (MAX(Wyniki_kreglarzy.WynikCzysty) >
                          (SELECT     MAX(WynikCzysty)
                            FROM          (Druzyny AS T2 INNER JOIN
                                                   Kreglarze AS B2 ON T2.IDDruzyny = B2.IDDruzyny) INNER JOIN
                                                   Wyniki_kreglarzy ON B2.IDKreglarza = Wyniki_kreglarzy.IDKreglarza
                            WHERE      T2.IDDruzyny = Druzyny.IDDruzyny AND B2.IDKreglarza <> Kreglarze.IDKreglarza));
GO

CREATE VIEW R14_dobrzy_kreglarze
AS
SELECT     Kreglarze.ImieKreglarza, Kreglarze.NazwiskoKreglarza, AVG(CAST(Wyniki_kreglarzy.WynikCzysty AS FLOAT)) AS SrdWynik
FROM         Kreglarze INNER JOIN
                      Wyniki_kreglarzy ON Kreglarze.IDKreglarza = Wyniki_kreglarzy.IDKreglarza
GROUP BY Kreglarze.ImieKreglarza, Kreglarze.NazwiskoKreglarza
HAVING      (AVG(CAST(Wyniki_kreglarzy.WynikCzysty AS FLOAT)) > 155);
GO

CREATE VIEW R18_kreglarze_165_bez_handicapu_Thunderbird_Bolero
AS 
SELECT Kreglarze.IDKreglarza, Kreglarze.NazwiskoKreglarza, Kreglarze.ImieKreglarza
FROM Kreglarze
WHERE Kreglarze.IDKreglarza NOT IN 
(SELECT Wyniki_kreglarzy.IDKreglarza 
FROM (Turnieje
INNER JOIN Mecze_turniejowe 
ON Turnieje.IDTurnieju = Mecze_turniejowe.IDTurnieju) 
INNER JOIN Wyniki_kreglarzy  
ON Mecze_turniejowe.IDMeczu = Wyniki_kreglarzy.IDMeczu
WHERE (Wyniki_kreglarzy.WynikCzysty > 165)
AND (Turnieje.LokalizacjaTurnieju IN ('Thunderbird Lanes', 'Bolero Lanes')));
GO


CREATE VIEW R18_kreglarze_wygrali_niskim_wynikiem_w_Thun_Totem_Bolero_DOBRZE
AS 
SELECT Kreglarze.IDKreglarza, Kreglarze.ImieKreglarza, Kreglarze.NazwiskoKreglarza, 
   Wyniki_kreglarzy.IDMeczu, Wyniki_kreglarzy.NumerGry, Wyniki_kreglarzy.WynikHandicap, 
   Turnieje.DataTurnieju, Turnieje.LokalizacjaTurnieju
FROM ((Kreglarze
INNER JOIN Wyniki_kreglarzy
ON Kreglarze.IDKreglarza=Wyniki_kreglarzy.IDKreglarza)
INNER JOIN Mecze_turniejowe
ON Wyniki_kreglarzy.IDMeczu=Mecze_turniejowe.IDMeczu)
INNER JOIN Turnieje
ON Turnieje.IDTurnieju=Mecze_turniejowe.IDTurnieju
WHERE (Wyniki_kreglarzy.WynikHandicap <= 190)
AND (Wyniki_kreglarzy.GraWygrana = 1)
AND (Turnieje.LokalizacjaTurnieju IN ('Thunderbird Lanes', 'Totem Lanes', 'Bolero Lanes')) 
AND (Kreglarze.IDKreglarza IN  (SELECT Wyniki_kreglarzy.IDKreglarza  FROM (Turnieje
INNER JOIN Mecze_turniejowe 
ON Turnieje.IDTurnieju = Mecze_turniejowe.IDTurnieju) 
INNER JOIN Wyniki_kreglarzy 
ON Mecze_turniejowe.IDMeczu = Wyniki_kreglarzy.IDMeczu WHERE Wyniki_kreglarzy.GraWygrana = 1 
AND Wyniki_kreglarzy.WynikHandicap <=190 
AND Turnieje.LokalizacjaTurnieju = 'Thunderbird Lanes'))
AND (Kreglarze.IDKreglarza IN  (SELECT Wyniki_kreglarzy.IDKreglarza  FROM (Turnieje
INNER JOIN Mecze_turniejowe 
ON Turnieje.IDTurnieju = Mecze_turniejowe.IDTurnieju) 
INNER JOIN Wyniki_kreglarzy 
ON Mecze_turniejowe.IDMeczu = Wyniki_kreglarzy.IDMeczu WHERE Wyniki_kreglarzy.GraWygrana = 1 
AND Wyniki_kreglarzy.WynikHandicap <=190 
AND Turnieje.LokalizacjaTurnieju = 'Totem Lanes'))
AND (Kreglarze.IDKreglarza IN (SELECT Wyniki_kreglarzy.IDKreglarza  FROM (Turnieje
INNER JOIN Mecze_turniejowe 
ON Turnieje.IDTurnieju = Mecze_turniejowe.IDTurnieju) 
INNER JOIN Wyniki_kreglarzy 
ON Mecze_turniejowe.IDMeczu = Wyniki_kreglarzy.IDMeczu WHERE Wyniki_kreglarzy.GraWygrana = 1 
AND Wyniki_kreglarzy.WynikHandicap <=190 
AND Turnieje.LokalizacjaTurnieju = 'Bolero Lanes'));
GO


CREATE VIEW R18_kreglarze_wygrali_niskim_wynikiem_w_Thun_Totem_Bolero_ZLE
AS 
SELECT Kreglarze.IDKreglarza, Kreglarze.ImieKreglarza, Kreglarze.NazwiskoKreglarza, 
   Wyniki_kreglarzy.IDMeczu, Wyniki_kreglarzy.NumerGry, Wyniki_kreglarzy.WynikHandicap, 
   Turnieje.DataTurnieju, Turnieje.LokalizacjaTurnieju
FROM ((Kreglarze
INNER JOIN Wyniki_kreglarzy
ON Kreglarze.IDKreglarza=Wyniki_kreglarzy.IDKreglarza)
INNER JOIN Mecze_turniejowe
ON Wyniki_kreglarzy.IDMeczu=Mecze_turniejowe.IDMeczu)
INNER JOIN Turnieje
ON Turnieje.IDTurnieju=Mecze_turniejowe.IDTurnieju
WHERE (Wyniki_kreglarzy.WynikHandicap<=190)
AND (Wyniki_kreglarzy.GraWygrana = 1)
AND (Turnieje.LokalizacjaTurnieju In ('Thunderbird Lanes','Totem Lanes','Bolero Lanes'));
GO


CREATE VIEW R18_dobrzy_kreglarze_Thunderbird_Bolero_EXISTS
AS 
SELECT Kreglarze.IDKreglarza, Kreglarze.NazwiskoKreglarza, Kreglarze.ImieKreglarza
FROM Kreglarze
WHERE EXISTS  
(SELECT *  
FROM (Turnieje
INNER JOIN Mecze_turniejowe 
ON Turnieje.IDTurnieju = Mecze_turniejowe.IDTurnieju) 
INNER JOIN Wyniki_kreglarzy  
ON Mecze_turniejowe.IDMeczu = Wyniki_kreglarzy.IDMeczu
WHERE (Wyniki_kreglarzy.IDKreglarza = Kreglarze.IDKreglarza) 
AND (Wyniki_kreglarzy.WynikCzysty >= 170)
AND (Turnieje.LokalizacjaTurnieju = 'Thunderbird Lanes'))
AND EXISTS  
(SELECT *  
FROM (Turnieje
INNER JOIN Mecze_turniejowe 
ON Turnieje.IDTurnieju = Mecze_turniejowe.IDTurnieju) 
INNER JOIN Wyniki_kreglarzy  
ON Mecze_turniejowe.IDMeczu = Wyniki_kreglarzy.IDMeczu
WHERE (Wyniki_kreglarzy.IDKreglarza = Kreglarze.IDKreglarza) 
AND (Wyniki_kreglarzy.WynikCzysty >= 170)
AND (Turnieje.LokalizacjaTurnieju = 'Bolero Lanes'));
GO


CREATE VIEW R18_przecietni_kreglarze
AS 
SELECT Kreglarze.IDKreglarza, Kreglarze.ImieKreglarza, Kreglarze.NazwiskoKreglarza
FROM Kreglarze
WHERE NOT EXISTS 
(SELECT * FROM Wyniki_kreglarzy 
WHERE Wyniki_kreglarzy.WynikCzysty > 150 
AND Wyniki_kreglarzy.IDKreglarza = Kreglarze.IDKreglarza);
GO


CREATE VIEW R18_turnieje_ktore_sie_jeszcze_nie_odbyly_NOT_IN
AS 
SELECT Turnieje.IDTurnieju, Turnieje.DataTurnieju, Turnieje.LokalizacjaTurnieju
FROM Turnieje
WHERE Turnieje.IDTurnieju NOT IN 
(SELECT Mecze_turniejowe.IDTurnieju 
FROM Mecze_turniejowe);
GO

CREATE VIEW R19_wszystkie_turnieje_dowolne_mecze
AS
SELECT  Turnieje.IDTurnieju, Turnieje.DataTurnieju, Turnieje.LokalizacjaTurnieju, 
        (CASE WHEN Mecze_turniejowe.IDMeczu IS NULL THEN 'Jeszcze nierozegrane' 
        ELSE 'Match: ' + CAST(Mecze_turniejowe.IDMeczu AS nvarchar) 
              + '  Tory: ' + Mecze_turniejowe.Tory + '  Tor nieparzysty druzyna: ' 
              + Druzyny.NazwaDruzyny + '  Tor parzysty druzyna: ' + Druzyny_1.NazwaDruzyny END) AS Match
FROM    ((Mecze_turniejowe INNER JOIN Druzyny 
        ON Mecze_turniejowe.IDDruzynyTorNieparzysty = Druzyny.IDDruzyny) 
        INNER JOIN Druzyny AS Druzyny_1 
        ON Mecze_turniejowe.IDDruzynyTorParzysty = Druzyny_1.IDDruzyny) 
        RIGHT OUTER JOIN Turnieje 
        ON Mecze_turniejowe.IDTurnieju = Turnieje.IDTurnieju;
GO

CREATE VIEW R19_wszystkie_mecze_turniejowe
AS
SELECT TOP (100) PERCENT Turnieje.DataTurnieju, Turnieje.LokalizacjaTurnieju, 
                         Mecze_turniejowe.Tory, Mecze_turniejowe.IDMeczu, Druzyny.NazwaDruzyny AS DruzynaTorNieparzysty, 
                         Druzyny_1.NazwaDruzyny AS DruzynaTorParzysty, WynikiGier.NumerGry, 
                         (CASE WHEN WynikiGier.NazwaDruzyny IS NULL 
                         THEN 'Mecz nierozegrany' ELSE WynikiGier.NazwaDruzyny END) AS Zwyciezca
FROM   (((Turnieje INNER JOIN Mecze_turniejowe 
       ON Turnieje.IDTurnieju = Mecze_turniejowe.IDTurnieju) 
       INNER JOIN Druzyny 
       ON Mecze_turniejowe.IDDruzynyTorNieparzysty = Druzyny.IDDruzyny) 
       INNER JOIN Druzyny AS Druzyny_1 
       ON Mecze_turniejowe.IDDruzynyTorParzysty = Druzyny_1.IDDruzyny) 
       LEFT OUTER JOIN
       (SELECT  Gry_meczowe.IDMeczu, Gry_meczowe.NumerGry, Druzyny_2.NazwaDruzyny
        FROM    Gry_meczowe INNER JOIN Druzyny AS Druzyny_2 
                ON Gry_meczowe.IDWygranejDruzyny = Druzyny_2.IDDruzyny) AS WynikiGier 
       ON Mecze_turniejowe.IDMeczu = WynikiGier.IDMeczu
ORDER BY Turnieje.DataTurnieju, Mecze_turniejowe.IDMeczu, WynikiGier.NumerGry;
GO

CREATE VIEW R19_srednie_wyniki_kreglarzy_z_pominieciem_0_gier

AS
SELECT  Kreglarze.IDKreglarza, Kreglarze.ImieKreglarza, Kreglarze.NazwiskoKreglarza, 
          COUNT(Wyniki_kreglarzy.IDMeczu) AS RozegraneGry, SUM(Wyniki_kreglarzy.WynikCzysty) AS SumaKregli, 
          (CASE COUNT(Wyniki_kreglarzy.IDMeczu) 
           WHEN 0 THEN 0 
           ELSE CAST((SUM(Wyniki_kreglarzy.WynikCzysty)/COUNT(Wyniki_kreglarzy.IDMeczu)) AS SmallInt) END) AS SredniaKreglarza
FROM    Kreglarze LEFT OUTER JOIN Wyniki_kreglarzy 
        ON Kreglarze.IDKreglarza = Wyniki_kreglarzy.IDKreglarza
GROUP BY Kreglarze.IDKreglarza, Kreglarze.ImieKreglarza, Kreglarze.NazwiskoKreglarza;
GO

CREATE VIEW R19_oceny_kreglarzy AS
SELECT   Kreglarze.IDKreglarza, Kreglarze.NazwiskoKreglarza, Kreglarze.ImieKreglarza, CAST(AVG(Wyniki_kreglarzy.WynikCzysty) AS Int) AS SredniaKreglarza, 
            (CASE WHEN CAST(AVG(Wyniki_kreglarzy.WynikCzysty) AS Int) < 140 THEN 'Przeciętny' 
                  WHEN CAST(AVG(Wyniki_kreglarzy.WynikCzysty) AS Int) < 160 THEN 'Niezły' 
                  WHEN CAST(AVG(Wyniki_kreglarzy.WynikCzysty) AS Int) < 185 THEN 'Dobry' 
                  ELSE 'Znakomity' END) AS PoziomKreglarza
FROM     Kreglarze INNER JOIN Wyniki_kreglarzy 
         ON Kreglarze.IDKreglarza = Wyniki_kreglarzy.IDKreglarza
GROUP BY Kreglarze.IDKreglarza, Kreglarze.NazwiskoKreglarza, Kreglarze.ImieKreglarza;
GO

CREATE VIEW R20_etykiety_do_wysylki_z_pominieciem_3
AS 
SELECT TOP 100 PERCENT * FROM
(SELECT ' ' As NazwiskoKreglarza, ' ' As ImieKreglarza, ' ' As AdresKreglarza, ' ' As MiastoKreglarza, ' ' As StanZamKreglarza, ' ' As KodPocztowyKreglarza
FROM ztblPomijanieEtykiet
WHERE ztblPomijanieEtykiet.LicznikEtykiet <= 3
UNION ALL SELECT NazwiskoKreglarza, ImieKreglarza, AdresKreglarza, MiastoKreglarza, StanZamKreglarza, KodPocztowyKreglarza
FROM Kreglarze) AS Blist
ORDER BY KodPocztowyKreglarza, NazwiskoKreglarza;
GO

CREATE VIEW R20_oceny_kreglarzy
AS 
SELECT WynikiKreglarzy.IDKreglarza, WynikiKreglarzy.NazwiskoKreglarza, WynikiKreglarzy.ImieKreglarza, WynikiKreglarzy.SredniaKreglarza, ztblPoziomKreglarza.PoziomKreglarza
FROM ztblPoziomKreglarza, (SELECT Kreglarze.IDKreglarza, Kreglarze.NazwiskoKreglarza, Kreglarze.ImieKreglarza, CAST(AVG(Wyniki_kreglarzy.WynikCzysty) AS Integer) AS SredniaKreglarza FROM Kreglarze
INNER JOIN Wyniki_kreglarzy 
ON Kreglarze.IDKreglarza=Wyniki_kreglarzy.IDKreglarza GROUP BY Kreglarze.IDKreglarza, Kreglarze.NazwiskoKreglarza, Kreglarze.ImieKreglarza)  AS WynikiKreglarzy
WHERE WynikiKreglarzy.SredniaKreglarza BETWEEN ztblPoziomKreglarza.SredniaNiskaKreglarza
AND ztblPoziomKreglarza.SredniaWysokaKreglarza;
GO

CREATE VIEW R20_zestawienia_druzyn
AS 
SELECT TOP 100 PERCENT Druzyny.IDDruzyny AS IDDruzyny1, Druzyny.NazwaDruzyny AS Nazwa1Druzyny, Druzyny_1.IDDruzyny AS IDDruzyny2, Druzyny_1.NazwaDruzyny AS Nazwa2Druzyny
FROM Druzyny, Druzyny AS Druzyny_1
WHERE Druzyny_1.IDDruzyny>Druzyny.IDDruzyny
ORDER BY Druzyny.IDDruzyny, Druzyny_1.IDDruzyny;
GO

CREATE VIEW R20_tygodniowy_harmonogram_turniejow_2012
AS 
SELECT ztblTygodnie.PoczatekTygodnia, (SELECT Turnieje.LokalizacjaTurnieju FROM Turnieje WHERE Turnieje.DataTurnieju BETWEEN ztblTygodnie.PoczatekTygodnia
AND ztblTygodnie.KoniecTygodnia) AS BowlingAlley
FROM ztblTygodnie
WHERE ztblTygodnie.PoczatekTygodnia <= '2012-12-31' And ztblTygodnie.KoniecTygodnia >= '2012-09-01';
GO

